<?php
// /auth/auth_handler.php - VERSI FINAL DENGAN KONEKSI DB
session_start();
date_default_timezone_set('Asia/Jakarta');

require 'config.php';

// --- PERBAIKAN: BUAT KONEKSI DATABASE DI SINI ---
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    error_log("Auth Handler DB Connection Failed: " . $conn->connect_error);
    http_response_code(500);
    die("Terjadi kesalahan pada server.");
}
$conn->set_charset("utf8mb4");
// --- AKHIR PERBAIKAN ---

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, password, role FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user_data = $result->fetch_assoc()) {
        if (password_verify($password, $user_data['password'])) {
            $token = bin2hex(random_bytes(32));
            $user_id = $user_data['id'];

            $expires_at = (new DateTime())->modify('+5 minutes')->format('Y-m-d H:i:s');

            $insert_stmt = $conn->prepare("INSERT INTO auth_tokens (token, user_id, expires_at) VALUES (?, ?, ?)");
            $insert_stmt->bind_param("sss", $token, $user_id, $expires_at);
            $insert_stmt->execute();

            header('Location: ' . PINPRI_URL . '/callback.php?token=' . $token);
            exit();
        }
    }

    header('Location: ' . AUTH_URL . '/login.php?error=Username atau password salah');
    exit();
}
?>